add_filter( 'sanitize_title', '_translate_slug_umlauts', 5, 3 );
/**
* Transliterates German umlauts in post slugs for both the classic and block editors.
*
* @param string $title The sanitized title.
* @param string $raw_title The title prior to any sanitization.
* @param string $context The context in which the sanitization is occurring.
*
* @return string The modified title with German umlauts transliterated.
*/
function _translate_slug_umlauts( $title, $raw_title = null, $context = 'query' ) {
// Hacky hook due to hacky core, see: http://core.trac.wordpress.org/ticket/16905
if ( $raw_title !== null ) {
$title = $raw_title; // undo remove_accents
}

// Replace umlauts and special characters with their transliterated equivalents.
$umlaut_replace = [
'Ä' => 'ae', 'ä' => 'ae',
'Ö' => 'oe', 'ö' => 'oe',
'Ü' => 'ue', 'ü' => 'ue',
'ẞ' => 'ss', 'ß' => 'ss'
];
$title = strtr( $title, $umlaut_replace );

if ( $context === 'save' ) {
$title = remove_accents( $title ); // redo remove_accents
}

return $title;
}