const observer = new MutationObserver((mutations) => {
  mutations.forEach((mutation) => {
    mutation.addedNodes.forEach((node) => {
      if (node.nodeType === 1 && !node["htmx-internal-data"]) {
        htmx.process(node)
      }
    })
  })
})
observer.observe(document, {childList: true, subtree: true})
