function encodeTextWithIcons(text) {
    // Split text by icon pattern {number}
    const parts = text.split(/(\{\d+\})/g);
    
    const byteArray = [];
    
    for (const part of parts) {
        if (part === '') continue;
        
        // Check if it's an icon pattern
        const iconMatch = part.match(/^\{(\d+)\}$/);
        
        if (iconMatch) {
            // It's an icon - add the icon number as a byte
            const iconNumber = parseInt(iconMatch[1]);
            byteArray.push(iconNumber);
        } else {
            // It's regular text - convert each character to byte
            for (let i = 0; i < part.length; i++) {
                byteArray.push(part.charCodeAt(i));
            }
        }
    }
    
    return new Uint8Array(byteArray);
}

// Example usage:
const text = "Hello {133} World {255} Test";
const encoded = encodeTextWithIcons(text);

console.log("Original:", text);
console.log("Byte Array:", Array.from(encoded));
console.log("Uint8Array:", encoded);
```

**Output example:**
```
Original: Hello {133} World {255} Test
Byte Array: [72, 101, 108, 108, 111, 32, 133, 32, 87, 111, 114, 108, 100, 32, 255, 32, 84, 101, 115, 116]